# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title bitwise operations 
#' @description
#' bitwise operations  in C++
#' @param a integer 
#' @param b integer
#' @keywords internal
#' @useDynLib prospectr
bitAND <- function(aa, bb) {
    .Call('prospectr_bitAND', PACKAGE = 'prospectr', aa, bb)
}

bitSR <- function(a, b) {
    .Call('prospectr_bitSR', PACKAGE = 'prospectr', a, b)
}

#' @title Convolve 
#' @description
#' Convolution, written in C++
#' @param X matrix to convolve
#' @param f filter
#' @keywords internal
#' @useDynLib prospectr
convCppM <- function(X, f) {
    .Call('prospectr_convCppM', PACKAGE = 'prospectr', X, f)
}

convCppV <- function(X, f) {
    .Call('prospectr_convCppV', PACKAGE = 'prospectr', X, f)
}

#' @title A fast distance algorithm for two matrices written in C++ 
#' @usage 
#' fastDist(X,Y,method)
#' @param X a \code{matrix}
#' @param Y a \code{matrix}
#' @param method a \code{string} with possible values "euclid", "cor", "cosine"
#' @return a distance \code{matrix}
#' @keywords internal
#' @useDynLib prospectr
#' @author Antoine Stevens and Leonardo Ramirez-Lopez
fastDist <- function(X, Y, method) {
    .Call('prospectr_fastDist', PACKAGE = 'prospectr', X, Y, method)
}

#' @title A fast distance algorithm for a matrix and a vector written in C++ 
#' @usage 
#' fastDistV(X,Y,method)
#' @param X a \code{matrix}
#' @param Y a \code{vector}
#' @param method a \code{string} with possible values "euclid", "cor", "cosine"
#' @return a distance \code{vector}
#' @author Antoine Stevens and Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib prospectr
fastDistV <- function(X, Y, method) {
    .Call('prospectr_fastDistV', PACKAGE = 'prospectr', X, Y, method)
}

#' @title Resample to given band position and fwhm
#' @description
#' Resample, written in C++
#' @param X matrix to resample
#' @param wav a numeric \code{vector} giving the original band positions
#' @param new_wav a numeric \code{vector} giving the new band positions
#' @param fwhm numeric \code{vector} giving the full width half maximums of the new band positions.
#' @keywords internal
#' @useDynLib prospectr
ResampleCppM <- function(X, wav, new_wav, fwhm) {
    .Call('prospectr_ResampleCppM', PACKAGE = 'prospectr', X, wav, new_wav, fwhm)
}

ResampleCppV <- function(X, wav, new_wav, fwhm) {
    .Call('prospectr_ResampleCppV', PACKAGE = 'prospectr', X, wav, new_wav, fwhm)
}

residLm <- function(Yr, Xr) {
    .Call('prospectr_residLm', PACKAGE = 'prospectr', Yr, Xr)
}

