% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{binning}
\alias{binning}
\title{Signal binning}
\usage{
binning(X, bins, bin.size)
}
\arguments{
\item{X}{a numeric matrix or vector to process (optionally a data frame that
can be coerced to a numerical matrix).}

\item{bins}{the number of bins.}

\item{bin.size}{the desired size of the bins.}
}
\value{
a matrix or vector with average values per bin.
}
\description{
Compute average values of a signal in pre-determined bins (col-wise subsets).
The bin size can be determined either directly or by specifying the number of
bins. Sometimes called boxcar transformation in signal processing
}
\examples{
data(NIRsoil)
wav <- as.numeric(colnames(NIRsoil$spc))

# 5 first spectra
matplot(wav, t(NIRsoil$spc[1:5, ]),
  type = "l",
  xlab = "Wavelength /nm",
  ylab = "Absorbance"
)

NIRsoil$spc_binned <- binning(NIRsoil$spc, bin.size = 20)

# bin means
matpoints(as.numeric(colnames(NIRsoil$spc_binned)),
  t(NIRsoil$spc_binned[1:5, ]),
  pch = 1:5
)

NIRsoil$spc_binned <- binning(NIRsoil$spc, bins = 20)
dim(NIRsoil$spc_binned) # 20 bins

# 5 first spectra
matplot(wav,
  t(NIRsoil$spc[1:5, ]),
  type = "l",
  xlab = "Wavelength /nm",
  ylab = "Absorbance"
)

# bin means
matpoints(as.numeric(colnames(NIRsoil$spc_binned)),
  t(NIRsoil$spc_binned[1:5, ]),
  pch = 1:5
)

}
\seealso{
\code{\link{savitzkyGolay}}, \code{\link{movav}},
\code{\link{gapDer}}, \code{\link{continuumRemoval}}
}
\author{
Antoine Stevens & \href{https://orcid.org/0000-0002-5369-5120}{Leonardo Ramirez-Lopez}
}
