% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.INDSCAL}
\alias{plot.INDSCAL}
\title{Plot an INDSCAL group configuration and source weights}
\usage{
\method{plot}{INDSCAL}(x, asp = 1, xlab = "X", ylab = "Y", xaxt = "n",
  yaxt = "n", ...)
}
\arguments{
\item{x}{an object of class \code{INDSCAL}}

\item{asp}{the aspect ratio of the plot}

\item{xlab}{a string with the label of the x axis}

\item{ylab}{a string with the label of the y axis}

\item{xaxt}{if = 'y', adds ticks to the x axis}

\item{yaxt}{if = 'y', adds ticks to the y axis}

\item{...}{optional arguments to the generic plot function}
}
\description{
Given an object of class \code{INDSCAL}, generates two plots: the
group configuration and the subject weights. Together, these
describe a 3-way MDS model.
}
\examples{
data(Namib)
plot(indscal(Namib$DZ,Namib$HM))
}
\seealso{
indscal
}

