% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/annotatePeptides.R
\name{annotatePeptides}
\alias{annotatePeptides}
\title{annotate peptides with protein ids}
\usage{
annotatePeptides(pepinfo, fasta, digestPattern = "(([RK])|(^)|(^M))",
  mcCores = NULL)
}
\arguments{
\item{pepinfo}{- list of peptides - sequence, optional modified sequence, charge state.}

\item{fasta}{- object as created by read.fasta in pacakge seqinr}

\item{digestPattern}{- default "(([RK])|(^)|(^M))"}

\item{mcCores}{number of cores to use}
}
\description{
annotate peptides with protein ids
}
\examples{
library(prozor)
library(doParallel)
library(foreach)
library(seqinr)
data(pepdata)
head(pepdata)

file = file.path(path.package("prozor"),"extdata/shortfasta.fasta" )
fasta = read.fasta(file = file, as.string = TRUE, seqtype="AA")
# we use a subset of the data to speedup the computation
#res = annotatePeptides(pepdata, fasta)
res = annotatePeptides(pepdata[1:20,], fasta,mcCores=1)
head(res)
}

