% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile.R
\name{prql_compile}
\alias{prql_compile}
\title{Compile a PRQL query into a SQL query}
\usage{
prql_compile(
  prql_query,
  target = getOption("prqlr.target", default = NULL),
  format = getOption("prqlr.format", default = TRUE),
  signature_comment = getOption("prqlr.signature_comment", default = TRUE)
)
}
\arguments{
\item{prql_query}{a PRQL query string.}

\item{target}{a compile target name to use. If not specified, the target contained in the query will be used.}

\item{format}{a logical flag. Whether to format the SQL query.}

\item{signature_comment}{a logical flag. Whether to add a signature comment to the output SQL query.}
}
\value{
a SQL query string
}
\description{
Compile a PRQL query into a SQL query
}
\examples{
"from mtcars | filter cyl > 6 | select [cyl, mpg]" |>
  prql_compile()

"from mtcars | filter cyl > 6 | select [cyl, mpg]" |>
  prql_compile(format = FALSE, signature_comment = FALSE)

"
from mtcars
filter cyl > 6
select ![cyl]
" |>
  prql_compile("sql.duckdb") |>
  cat()

# If the `target` argument is `NULL` (default) or `NA` or `"sql.any"`,
# the target specified in the header of the query will be used.
"
prql target:sql.duckdb

from mtcars
filter cyl > 6
select ![cyl]
" |>
  prql_compile() |>
  cat()
}
\seealso{
\link{prql_get_targets}
}
