% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify-call.R
\name{modify_call}
\alias{modify_call}
\title{Modify the arguments of a call.}
\usage{
modify_call(call, new_args)
}
\arguments{
\item{call}{A call to modify. It is first standardised with
\code{\link{standardise_call}}.}

\item{new_args}{A named list of expressions (constants, names or calls)
used to modify the call. Use \code{NULL} to remove arguments.}
}
\description{
Modify the arguments of a call.
}
\examples{
call <- quote(mean(x, na.rm = TRUE))

# Modify an existing argument
modify_call(call, list(na.rm = FALSE))
modify_call(call, list(x = quote(y)))

# Remove an argument
modify_call(call, list(na.rm = NULL))

# Add a new argument
modify_call(call, list(trim = 0.1))

# Add an explicit missing argument
modify_call(call, list(na.rm = quote(expr = )))
}
