% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Getters.R
\name{DDGet}
\alias{DDGet}
\title{Downloads the Democracy and Dictatorship data set}
\usage{
DDGet(url = "http://uofi.box.com/shared/static/bba3968d7c3397c024ec.dta",
  vars = NULL, OutCountryID = "iso2c", standardCountryName = TRUE,
  na.rm = TRUE, duplicates = "message", fromLast = FALSE)
}
\arguments{
\item{url}{character string. The URL for the Democracy and Dictatorship data
set you would like to download. Note: it must be for the Stata version of
the file.}

\item{vars}{character vector containing the variables to keep. If
\code{vars = NULL} then the entire data set is returned. Note that the
\code{country} and \code{year} variables are always returned.}

\item{OutCountryID}{character string. The type of country ID you would like
to include in the output file along with the country name. See
\code{\link{countrycode}} for available options.}

\item{standardCountryName}{logical. Whether or not to standardise the country
names variable based on \code{country.name} from  \code{\link{countrycode}}.}

\item{na.rm}{logical. Drop observations where \code{OutCountryID} is
\code{NA}.}

\item{duplicates}{character specifying how to handle duplicated country-year
observations. Can be set to \code{none} to do nothing, \code{message} to
simply report duplicates, \code{drop} to report and drop duplicates, and
\code{return} to return a data frame with only duplicated observations
(see also \code{fromLast}).}

\item{fromLast}{logical indicating if duplication should be considered from
the reverse side. Only relevant if \code{duplicates = 'drop'} or
\code{duplicates = 'out'}.}
}
\value{
a data frame
}
\description{
Downloads the Democracy and Dictatorship data set. It keeps specified
variables and creates a standard country ID variable that can be used for
merging the data with other data sets.
See the codebook at the authors' website
\url{https://sites.google.com/site/joseantoniocheibub/datasets/democracy-and-dictatorship-revisited}
(Direct link to codebook: \url{http://uofi.box.com/shared/static/e6e312753fbc609fc379.pdf})
}
\examples{
\dontrun{
# Download full data set
DDData <- DDGet()
}

}
\seealso{
\code{\link{countrycode}}, \code{\link{CountryID}}
}

