% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data_baseline.R
\name{binary_cutoff}
\alias{binary_cutoff}
\title{Binary Cut-Off Transformation}
\usage{
binary_cutoff(name, int_cutoff, ext_cutoff)
}
\arguments{
\item{name}{variable to transform}

\item{int_cutoff}{cut-off for internal patients, numeric between 0 and 1}

\item{ext_cutoff}{cut-off for external patients, numeric between 0 and 1}
}
\value{
Transformation function to be used in \code{\link[=create_baseline_object]{create_baseline_object()}}.
Sets quantile values larger than cut-off value to \code{TRUE} otherwise \code{FALSE}.
}
\description{
Binary Cut-Off Transformation
}
\examples{
# Creates a simple function, where `data` is a `BaselineDataFrame`:
function(data) {
  ext <- data$ext == 0
  q <- get_quantiles(data, name)
  ifelse(ext, q > int_cutoff, q > ext_cutoff)
}

}
