% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudohouseholds.R
\name{validate_phhs}
\alias{validate_phhs}
\title{Validate Pseudohouseholds (PHHs)}
\usage{
validate_phhs(phhs, regions, region_idcol, region_popcol)
}
\arguments{
\item{phhs}{A data frame containing a set of PHHs.}

\item{regions}{A simple feature object, sf tibble where each row is a region,
used to generate the PHHs.}

\item{region_idcol}{Character, the name of the column in both `phhs` and `regions`
containing regional identifiers.}

\item{region_popcol}{Character, the name of the column in both `phhs` and `regions`
containing population data.}
}
\value{
A data frame containing test outputs.
}
\description{
This function runs two tests to ensure that PHHs meet minimal criteria for
validity: it checks to see whether PHH populations sum accurately to region
populations, and whether each populated region has at least one PHH. Results
are returned in a data frame, and any failing regions are returned in a list-
column that can be used for filtering and further analysis. Note that these
tests may fail if PHHs were generated without using population data.
}
\examples{
phhs <- get_phhs_single(region = region_shp, region_idcol = "region_id",
region_popcol = "population", roads = road_shp, roads_idcol = "road_id")
validate_phhs(phhs = phhs, regions = region_shp, region_idcol = "region_id",
region_popcol = "population")
}
