% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppdpps.R
\name{calc_haz_psm}
\alias{calc_haz_psm}
\title{Derive pre and post-progression hazards of death under PSM}
\usage{
calc_haz_psm(timevar, ptdata, dpam, psmtype)
}
\arguments{
\item{timevar}{Vector of times at which to calculate the hazards}

\item{ptdata}{Dataset of patient level data. Must be a tibble with columns named:
\itemize{
\item ptid: patient identifier
\item pfs.durn: duration of PFS from baseline
\item pfs.flag: event flag for PFS (=1 if progression or death occurred, 0 for censoring)
\item os.durn: duration of OS from baseline
\item os.flag: event flag for OS (=1 if death occurred, 0 for censoring)
\item ttp.durn: duration of TTP from baseline (usually should be equal to pfs.durn)
\item ttp.flag: event flag for TTP (=1 if progression occurred, 0 for censoring).
}

Survival data for all other endpoints (time to progression, pre-progression death, post-progression survival) are derived from PFS and OS.}

\item{dpam}{List of survival regressions for each endpoint:
\itemize{
\item pre-progression death (PPD)
\item time to progression (TTP)
\item progression-free survival (PFS)
\item overall survival (OS)
\item post-progression survival clock forward (PPS-CF) and
\item post-progression survival clock reset (PPS-CR).
}}

\item{psmtype}{Either "simple" or "complex" PSM formulation}
}
\value{
List of pre, the pre-progression hazard, and post, the post-progression hazard
}
\description{
Derive the hazards of death pre- and post-progression under either simple or complex PSM formulations.
}
\examples{
\donttest{
bosonc <- create_dummydata("flexbosms")
fits <- fit_ends_mods_spl(bosonc)
# Pick out best distribution according to min AIC
params <- list(
  ppd = find_bestfit(fits$ppd, "aic")$fit,
  ttp = find_bestfit(fits$ttp, "aic")$fit,
  pfs = find_bestfit(fits$pfs, "aic")$fit,
  os = find_bestfit(fits$os, "aic")$fit,
  pps_cf = find_bestfit(fits$pps_cf, "aic")$fit,
  pps_cr = find_bestfit(fits$pps_cr, "aic")$fit
  )
calc_haz_psm(0:10, ptdata=bosonc, dpam=params, psmtype="simple")
calc_haz_psm(0:10, ptdata=bosonc, dpam=params, psmtype="complex")
}
}
