% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_impactsnopar.R
\name{plot_impactsnopar}
\alias{plot_impactsnopar}
\title{Plot direct, indirect and total impacts  functions 
  for continous non-parametric covariates in semiparametric spatial regression models.}
\usage{
plot_impactsnopar(
  impactsnopar,
  data,
  smooth = TRUE,
  span = c(0.1, 0.1, 0.2),
  dynamic = FALSE,
  nt = NULL
)
}
\arguments{
\item{impactsnopar}{object returned from \code{\link{impactsnopar}} function.}

\item{data}{dataframe with the data.}

\item{smooth}{logical value to choose smoothing of the effects function
prior to plot. Default TRUE.}

\item{span}{span for the kernel of the smoothing (see \code{\link{loess}} 
for details). Default c(0.1, 0.1, 0.2).}

\item{dynamic}{Logical value to set a dynamic model.
Dynamic models include a temporal lag of the dependent
variable in the right-hand side of the equation.
Default = `FALSE`.}

\item{nt}{Number of temporal periods. It is needed
for dynamic models.}
}
\value{
plot of the direct, indirect and total impacts  function for each non-parametric
  covariate included in the object returned from \code{\link{impactsnopar}}.
}
\description{
Plot direct, indirect and total impacts functions for 
  non-parametric covariates included in a semiparametric spatial
  or spatio-temporal SAR model. This model must include a spatial
  lag of the dependent variable (SAR) to have indirect effects 
  different from 0, otherwise, total and direct function effects 
  are the same. The effect functions can be smoothed to overcome 
  the instabilities created by the premultiplication of matrix
  \eqn{(I - \rho W)^{-1}}
}
\examples{
################################################
###################### Examples using a panel data of rate of
###################### unemployment for 103 Italian provinces in period 1996-2014.
library(pspatreg)
data(unemp_it)
## Wsp_it is a matrix. Create a neighboord list 
lwsp_it <- spdep::mat2listw(Wsp_it)
## short sample for spatial pure case (2d)
unemp_it_short <- unemp_it[unemp_it$year == 2019, ]  
########  No Spatial Trend: PSAR including a spatial 
########  lag of the dependent variable
form1 <- unrate ~ partrate + agri + cons +
                  pspl(serv, nknots = 15) +
                  pspl(empgrowth, nknots = 20) 
gamsar <- pspatfit(form1, data = unemp_it_short, 
                   type = "sar", 
                   listw = lwsp_it)
summary(gamsar)
###### Non-Parametric Total, Direct and Indirect impacts
imp_nparvar <- impactsnopar(gamsar, 
                            listw = lwsp_it, 
                            viewplot = TRUE)  
##### This returns the same result but using plot_impactsnopar()
imp_nparvar <- impactsnopar(gamsar, listw = lwsp_it, 
                            viewplot = FALSE)
plot_impactsnopar(imp_nparvar, data = unemp_it_short, 
                   smooth = TRUE, 
                   dynamic = FALSE,
                   nt = 24)

}
\references{
\itemize{ 
    \item Basile, R.; Durban, M.; Minguez, R.; Montero, J. M.; and 
    Mur, J. (2014). Modeling regional economic dynamics: Spatial
    dependence, spatial heterogeneity and nonlinearities. 
    \emph{Journal of Economic Dynamics and Control}, (48), 229-245.
    <doi:10.1016/j.jedc.2014.06.011>               
 }
}
\seealso{
\itemize{
  \item \code{\link{impactsnopar}} compute total, direct and indirect effect
          functions for non-parametric continuous covariates.
  \item \code{\link{fit_terms}} compute smooth functions for non-parametric
                                continuous covariates.
  \item \code{\link{plot_terms}} plot the terms of non-parametric covariates.
}
}
\author{
\tabular{ll}{ 
  Roman Minguez  \tab \email{roman.minguez@uclm.es} \cr
  Roberto Basile \tab \email{roberto.basile@univaq.it} \cr 
  Maria Durban \tab \email{mdurban@est-econ.uc3m.es} \cr 
  Gonzalo Espana-Heredia \tab \email{gehllanza@gmail.com} \cr 
 }
}
