% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_functions.r
\name{shuffle}
\alias{shuffle}
\title{Shuffle coefficients and standard errors together}
\usage{
shuffle(b, pv, se, alpha = 0.05, digits = 3, names = NULL)
}
\arguments{
\item{b}{Vector of coefficients}

\item{pv}{Vector of p-values corresponding to \code{b}}

\item{se}{Vector of standard errors corresponding to \code{b}}

\item{alpha}{Alpha level for the significance flag}

\item{digits}{Number of digits to print}

\item{names}{A character vector of coefficient names as long as \code{b}}
}
\value{
A character vector of printed output
}
\description{
Function shuffles together coefficients and standard errors with a significance flag.
}
\examples{

library(nnet)
data(repress)
mrm <- multinom(pts_s ~ pr + cwar + iwar +  log(rgdpe) + log(pop), data=repress)
b <- coef(mrm)
v <- vcov(mrm)
b <- c(t(b))
se <- sqrt(diag(v))
pv <- 2*pnorm(abs(b/se), lower.tail=FALSE)
tab11_7 <- matrix(shuffle(b, pv, se), ncol=4)
rownames(tab11_7) <- rep("", 12)
rownames(tab11_7)[seq(1, 12, by=2)] <- colnames(coef(mrm))
colnames(tab11_7) <- paste0("PTS = ", 2:5)
noquote(tab11_7)
}
