% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_test.R
\name{cor_test}
\alias{cor_test}
\title{Correlation table}
\usage{
cor_test(
  data,
  cols,
  ...,
  digits = 3,
  method = "pearson",
  p_adjust = "holm",
  streamline = FALSE,
  quite = FALSE,
  return_result = FALSE
)
}
\arguments{
\item{data}{data frame}

\item{cols}{correlation items. Support \code{dplyr::select()} syntax.}

\item{...}{additional arguments passed to correlation::correlation(). See ?correlation::correlation. Note that the return data.frame from correlation::correlation() must contains \code{r} and \code{p} (e.g., passing \code{baysesian = TRUE} will not work)}

\item{digits}{number of digits to round to}

\item{method}{Default is "pearson". Options are "kendall", "spearman","biserial", "polychoric", "tetrachoric", "biweight", "distance", "percentage", "blomqvist", "hoeffding", "gamma", "gaussian","shepherd", or "auto". See ?correlation::correlation for detail}

\item{p_adjust}{Default is "holm". Options are "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "somers" or "none". See ?stats::p.adjust for more detail}

\item{streamline}{print streamlined output.}

\item{quite}{suppress printing output}

\item{return_result}{If it is set to \code{TRUE}, it will return the data frame of the correlation table}
}
\value{
a \code{data.frame} of the correlation table
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \cr
This function uses the \code{correlation::correlation()} to generate the correlation table.
}
\examples{
cor_test(iris, where(is.numeric))
}
