% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_fit.R
\name{compare_fit}
\alias{compare_fit}
\title{Comparison of Model Fit}
\usage{
compare_fit(
  ...,
  digits = 3,
  quite = FALSE,
  streamline = FALSE,
  return_result = FALSE
)
}
\arguments{
\item{...}{model. If it is a \code{lavaan} object, it will try to compute the measurement invariance. Other model types will be passed to \code{performance::compare_performance()}.}

\item{digits}{number of digits to round to}

\item{quite}{suppress printing output}

\item{streamline}{print streamlined output}

\item{return_result}{If it is set to \code{TRUE}, it will return the the compare fit data frame.}
}
\value{
a \code{dataframe} with fit indices and change in fit indices
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \cr
Compare the fit indices of models (see below for model support)
}
\examples{
# lme model

fit1 <- lm_model(
  data = popular,
  response_variable = popular,
  predictor_var = c(sex, extrav)
)

fit2 <- lm_model(
  data = popular,
  response_variable = popular,
  predictor_var = c(sex, extrav),
  two_way_interaction_factor = c(sex, extrav)
)

compare_fit(fit1, fit2)

# see ?measurement_invariance for measurement invariance example
}
