% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composites.R
\name{composite_u_matrix}
\alias{composite_u_matrix}
\title{Matrix formula to estimate the u ratio of a composite variable}
\usage{
composite_u_matrix(ri_mat = NULL, ra_mat = NULL, u_vec, wt_vec = rep(1,
  length(u_vec)), sign_r_vec = 1)
}
\arguments{
\item{ri_mat}{Range-restricted correlation matrix from which the composite is to be computed (if \code{NULL}, \code{ri_mat} is estimated from \code{ra_mat}).}

\item{ra_mat}{Unrestricted correlation matrix from which the composite is to be computed (if \code{NULL}, \code{ra_mat} is estimated from \code{ri_mat}).}

\item{u_vec}{Vector of u ratios associated with variables in the composite to be formed.}

\item{wt_vec}{Weights to be used in forming the composite (by default, all variables receive equal weight).}

\item{sign_r_vec}{The signs of the relationships between the variables in the composite and the variable by which range restriction was induced.}
}
\value{
The estimated \emph{u} ratio of the composite variable.
}
\description{
This function estimates the u ratio of a composite variable when at least one matrix of correlations (restricted or unrestricted) among the variables is available.
}
\details{
This is computed as:

\deqn{u_{composite}=\sqrt{\frac{\left(\mathbf{w}\circ\mathbf{u}\right)^{T}\mathbf{R}_{i}\left(\mathbf{w}\circ\mathbf{u}\right)}{\mathbf{w}^{T}\mathbf{R}_{a}\mathbf{w}}}}{u_composite = sqrt((t(wt * u)  R_i  (wt * u) / (t(wt)  R_a  wt))}

where \eqn{u_{composite}}{u_composite} is the composite u ratio, \eqn{\mathbf{u}}{u} is a vector of u ratios, \eqn{\mathbf{R}_{i}}{R_i} is a range-restricted correlation matrix, \eqn{\mathbf{R}_{a}}{R_a} is an unrestricted correlation matrix, and \eqn{\mathbf{w}}{wt} is a vector of weights.
}
\examples{
composite_u_matrix(ri_mat = matrix(c(1, .3, .3, 1), 2, 2), u_vec = c(.8, .8))
}
