% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_psych.R
\name{simulate_psych}
\alias{simulate_psych}
\title{Simulate Monte Carlo psychometric data (observed, true, and error scores)}
\usage{
simulate_psych(n, rho_mat, mu_vec = rep(0, ncol(rho_mat)),
  sigma_vec = rep(1, ncol(rho_mat)), rel_vec = rep(1, ncol(rho_mat)),
  sr_vec = rep(1, ncol(rho_mat)), wt_mat = NULL, sr_composites = NULL,
  var_names = NULL, composite_names = NULL)
}
\arguments{
\item{n}{Number of cases to simulate before performing selection. If \code{Inf}, function will simulate parameter values.}

\item{rho_mat}{Matrix of true-score correlations.}

\item{mu_vec}{Vector of means.}

\item{sigma_vec}{Vector of observed-score standard deviations.}

\item{rel_vec}{Vector of reliabilities corresponding to the variables in \code{rho_mat.}}

\item{sr_vec}{Vector of selection ratios corresponding to the variables in \code{rho_mat}
(set selection ratios to 1 for variables that should not be used in selection).}

\item{wt_mat}{Optional matrix of weights to use in forming a composite of the variables in \code{rho_mat.} Matrix should have as many rows (or vector elements) as there are variables in \code{rho_mat}.}

\item{sr_composites}{Optional vector selection ratios for composite variables. If not \code{NULL}, \code{sr_composites} must have as many elements as there are columns in \code{wt_mat}.}

\item{var_names}{Vector of variable names corresponding to the variables in \code{rho_mat}.}

\item{composite_names}{Optional vector of names for composite variables.}

\item{...}{Further arguments.}
}
\value{
A list of observed-score, true-score, and error-score data frames. If selection is requested, the data frames will include logical variables indicating whether each case would be selected on the basis of observed scores, true scores, and error scores.
}
\description{
Simulate Monte Carlo psychometric data (observed, true, and error scores)
}
\examples{
## Generate data for a simple sample with two variables without selection:
simulate_psych(n = 1000, rho_mat = matrix(c(1, .5, .5, 1), 2, 2), sigma_vec = c(1, 1),
          rel_vec = c(.8, .8), var_names = c("Y", "X"))

## Generate data for a simple sample with two variables with selection:
simulate_psych(n = 1000, rho_mat = matrix(c(1, .5, .5, 1), 2, 2), sigma_vec = c(1, 1),
          rel_vec = c(.8, .8), sr_vec = c(1, .5), var_names = c("Y", "X"))

## Generate data for samples with five variables, of which subsets are used to form composites:
rho_mat <- matrix(.5, 5, 5)
diag(rho_mat) <- 1
simulate_psych(n = 1000, rho_mat = rho_mat,
                rel_vec = rep(.8, 5), sr_vec = c(1, 1, 1, 1, .5),
                wt_mat = cbind(c(0, 0, 0, .3, 1), c(1, .3, 0, 0, 0)), sr_composites = c(.7, .5))
}
\keyword{datagen}
