% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_ma.R
\name{filter_ma}
\alias{filter_ma}
\alias{filter_meta}
\title{Filter meta-analyses}
\usage{
filter_ma(ma_obj, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, ...)

filter_meta(ma_obj, analyses = "all", match = c("all", "any"),
  case_sensitive = TRUE, ...)
}
\arguments{
\item{ma_obj}{A psychmeta meta-analysis object.}

\item{analyses}{Which analyses to extract? Can be either \code{"all"} to extract references for all meta-analyses in the object (default) or a list containing one or more of the following arguments:
\itemize{
\item{construct:}{ A list or vector of construct names to search for.}
\item{construct_pair:}{ A list of vectors of construct pairs to search for. \cr
(e.g., \code{list(c("X", "Y"), c("X", "Z"))}).}
\item{pair_id:}{ A list or vector of numeric construct pair IDs (unique construct-pair indices).}
\item{analysis_id:}{ A list or vector of numeric analysis IDs (unique analysis indexes).}
\item{k_min:}{ A numeric value specifying the minimum \code{k} for extracted meta-analyses.}
\item{N_minv}{ A numeric value specifying the minimum \code{N} for extracted meta-analyses.}
}}

\item{match}{Should extracted meta-analyses match all (default) or any of the criteria given in \code{analyses}?}

\item{case_sensitive}{Logical scalar that determines whether character values supplied in \code{analyses} should be treated as case sensitive (\code{TRUE}, default) or not (\code{FALSE}).}

\item{...}{Additional arguments.}
}
\value{
A \code{psychmeta} meta-analysis object with analyses matching the specified criteria.
}
\description{
Filter \code{psychmeta} meta-analysis objects based on specified criteria.
}
\examples{
ma_obj <- ma_r(ma_method = "ic", rxyi = rxyi, n = n, rxx = rxxi, ryy = ryyi,
               construct_x = x_name, construct_y = y_name, sample_id = sample_id, citekey = NULL,
               moderators = moderator, data = data_r_meas_multi,
               impute_artifacts = FALSE, clean_artifacts = FALSE)
ma_obj <- ma_r_ad(ma_obj, correct_rr_x = FALSE, correct_rr_y = FALSE)

filter_ma(ma_obj, analyses="all")
filter_ma(ma_obj, analyses=list(construct="X"), match="all")
filter_ma(ma_obj, analyses=list(construct="X", k_min=21), match="any")
filter_ma(ma_obj, analyses=list(construct="X", k_min=21), match="all")
}
