% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdi.R
\name{HDI}
\alias{HDI}
\title{Highest Density Intervals (HDI).}
\usage{
HDI(x, prob = 0.95)
}
\arguments{
\item{x}{A vector of values from a probability distribution (e.g., posterior probabilities from MCMC sampling).}

\item{prob}{Scalar between 0 and 1, indicating the mass within the credible interval that is to be estimated.}
}
\description{
Compute the Highest Density Intervals (HDI) of a distribution.
}
\examples{
library(psycho)

distribution <- rnorm(1000, 0, 1)
HDI_values <- HDI(distribution)
print(HDI_values)
plot(HDI_values)
summary(HDI_values)

x <- matrix(rexp(200), 100)
HDI_values <- HDI(x)
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
