% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetSatVapPres}
\alias{GetSatVapPres}
\title{Return saturation vapor pressure given dry-bulb temperature.}
\usage{
GetSatVapPres(TDryBulb)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}
}
\value{
A numeric vector of vapor pressure of saturated air in Psi [IP] or Pa [SI]
}
\description{
Return saturation vapor pressure given dry-bulb temperature.
}
\note{
Important note: the ASHRAE formulae are defined above and below the freezing point but have
a discontinuity at the freezing point. This is a small inaccuracy on ASHRAE's part: the formulae
should be defined above and below the triple point of water (not the feezing point) in which case
the discontinuity vanishes. It is essential to use the triple point of water otherwise function
GetTDewPointFromVapPres, which inverts the present function, does not converge properly around
the freezing point.
}
\examples{
SetUnitSystem("IP")
GetSatVapPres(80:100)

SetUnitSystem("SI")
GetSatVapPres(20:30)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1  eqn 5 & 6
}
