% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddG.R
\name{foldx.mut}
\alias{foldx.mut}
\title{Compute Changes in Stability (DDG)}
\usage{
foldx.mut(pdb, ch, pos, newres = "", pH =7, method = "buildmodel", keepfiles = FALSE)
}
\arguments{
\item{pdb}{the 4-letter identifier of a PDB structure or the path to a PDB file.}

\item{ch}{a letter identifying the chain of interest.}

\item{pos}{the position, in the primary structure, of the residue to be mutated.}

\item{newres}{the one letter code of the residue to be incorporated. When a value is not entered for this parameter, then the function will compute DDG for the mutation to any possible amino acid (including phosphoserine, phosphothreonine, phosphotyrosine and hydroxiproline in the case of the 'positionscan' method).}

\item{pH}{a numeric value between 0 and 14.}

\item{method}{a character string specifying the approach to be used; it must be one of 'buildmodel', 'positionscan'.}

\item{keepfiles}{logical, when TRUE the repaired PDB file is saved in the working directory.}
}
\value{
The function computes and returns the DDG (kcal/mol) for the requested residue change, defined as DDG = DGmt - DGwt, where DG is the Gibbs free energy for the folding of the protein from its unfolded state. Thus, a positive value means a destabilizing effect, and vice versa.
}
\description{
Computes changes in the stability of a protein after a residue mutation using a force-field approach.
}
\details{
Two computational approaches for prediction of the effect of amino acid changes on protein stability are implemented. FoldX (buildmodel and positionscan methods) uses a force field approach and although it has been proved to be satisfactorily accurate, it is also a time-consuming method. An alternative much faster is I-Mutant, a method base on machine-learning
}
\examples{
\dontrun{foldx('1aaq', 'A', 45, 'R')}
}
\references{
Schymkowitz et al (2005) Nucl. Ac. Res. 33:W382-W388.
}
\seealso{
imutant(), ddG.profile()
}
\author{
Juan Carlos Aledo
}
