% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{alpha_mle}
\alias{alpha_mle}
\title{Estimating the Shape Parameter by Method of Maximum Likelihood (MLE)}
\usage{
alpha_mle(dat, biased = TRUE, significance = NULL)
}
\arguments{
\item{dat}{vector of observations}

\item{biased}{TRUE/FALSE to indicate biased or unbiased estimates}

\item{significance}{level of significance}
}
\value{
A list of the following form:
\describe{
  \item{shape}{Estimate of the shape parameter of the data}
  \item{lower_bound}{Upper error bound of the estimate of shape}
  \item{upper_bound}{Lower error bound of the estimate of shape}
  \item{scale}{Estimate of the scale parameter of the data (which is taken
  to be the minimum of the data)}
}
}
\description{
This function can be used to estimate the \code{shape} parameter using the 
Maximum Likelihood Estimator method (Newman 2005). It can be used to 
obtain biased and unbiased estimates of the shape and scale parameters as 
well as the confidence interval for the shape parameter for the biased estimates.
}
\examples{
x <- generate_pareto(10000, 5, 2)
alpha_mle(x, TRUE, 0.05)

x <- generate_pareto(10000, 5, 2)
alpha_mle(x, FALSE)

}
\references{
Newman MEJ (2005). "Power Laws, Pareto Distributions And Zipf's Law." 
Contemporary Physics, 46, 323-351.
}
