% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disruptions.R
\name{all_disruptions_to_tibble}
\alias{all_disruptions_to_tibble}
\title{Convert the contents of a disruptions API call to a single tibble}
\usage{
all_disruptions_to_tibble(disruptions_content)
}
\arguments{
\item{disruptions_content}{The raw disruptions content returned by the
\code{disruptions} API call.}
}
\value{
A tibble with the following columns: \itemize{
\item \code{disruption_mode}
\item \code{disruption_mode_description}
\item \code{disruption_id}
\item \code{title}
\item \code{url}
\item \code{description}
\item \code{disruption_status}
\item \code{disruption_type}
\item \code{published_on}
\item \code{last_updated}
\item \code{from_date}
\item \code{to_date}
\item \code{routes}
\item \code{stops}
\item \code{colour}
\item \code{display_on_board}
\item \code{display_status}
}
}
\description{
Disruptions API responses contain an element for every service type, eg.
metro train, taxis, Skybus. Normally we would map-reduce the content of an
API call with a function analogous to \code{disruption_to_tibble}. But because of
the extra layer of nesting in the response, we have to map-reduce the service
types first.
}
\details{
Note that we return an empty tibble if there are no disruptions, so that
this situation is omitted.
}
\keyword{internal}
