% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Rothman}
\alias{Rothman}
\title{Oral contraceptives and stroke.}
\format{
A labelled tibble with 477 rows and 3 variables:
\describe{
\item{stroke}{Thrombotic stroke, factor with levels "No" and "Yes".}
\item{oc}{Current user of oral contraceptives, factor with levels "Non-user" and "User".}
\item{ht}{Hypertension, factor with levels "No" (<160/95 mm Hg) and "Yes".}
}
}
\source{
Collaborative Group for the Study of Stroke in Young Women (1975) Oral contraceptives and stroke in
young women. JAMA 231:718-722.

Rothman, KJ (2002) Epidemiology. An Introduction. Oxford University Press.
}
\usage{
Rothman
}
\description{
A case-control study of oral contraceptives and stroke in young women with presence or absence of hypertension.
Cases represent thrombotic stroke and controls are hospital controls. The group of no hypertension includes
normal blood pressure (<140/90 mm Hg) and borderline hypertension (140-159/90-94 mm Hg). Hypertension group
includes moderate hypertension (160-179/95-109 mm Hg) and severe hypertension (180+/110+ mm Hg). This data has
been used as an example of join exposure by Rothman for measuring interactions (see examples).
}
\examples{
data(Rothman)

cross_tab(stroke ~ oc + ht, data = Rothman)

mhor(stroke ~ ht/oc, data = Rothman)

## Model with standard interaction term:
model1 <- glm(stroke ~ ht*oc, data = Rothman, family = binomial)
glm_coef(model1)

## Model considering join exposure:
Rothman$join <- 0
Rothman$join[Rothman$oc == "Non-user" & Rothman$ht == "Yes"] <- 1
Rothman$join[Rothman$oc == "User" & Rothman$ht == "No"] <- 2
Rothman$join[Rothman$oc == "User" & Rothman$ht == "Yes"] <- 3
Rothman$join <- factor(Rothman$join, labels=c("Unexposed", "Hypertension", "OC user",
                       "OC and hypertension"))

require(sjlabelled)
Rothman$join <- set_label(Rothman$join, label = "Exposure")

cross_tab(stroke ~ join, data = Rothman)

model2 <- glm(stroke ~ join, data = Rothman, family = binomial)
glm_coef(model2)
odds_trend(stroke ~ join, data = Rothman)$df
odds_trend(stroke ~ join, data = Rothman)$fig
}
\keyword{datasets}
