% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_functions.R
\name{glm_coef}
\alias{glm_coef}
\title{Table of coefficients from generalised linear models.}
\usage{
glm_coef(
  model,
  digits = 2,
  alpha = 0.05,
  labels = NULL,
  se_rob = TRUE,
  type = "cond",
  exp_norm = FALSE
)
}
\arguments{
\item{model}{A model from any of the classes listed in the details section.}

\item{digits}{A scalar, number of digits for rounding the results (default = 2).}

\item{alpha}{Significant level (default = 0.05) used to calculate confidence intervals.}

\item{labels}{An optional character vector with the names of the coefficients (including intercept).}

\item{se_rob}{Logical, should robust errors be used to calculate confidence intervals? (default = TRUE).}

\item{type}{Character, either "cond" (condensed) or "ext" (extended). See details.}

\item{exp_norm}{Logical, should estimates and confidence intervals should be exponentiated? (for family == "gaussian").}
}
\value{
A data frame with estimates, confidence intervals and p-values from \code{glm} objects.
}
\description{
\code{glm_coef} displays estimates with confidence intervals and p-values from generalised linear models (see Details).
}
\details{
\code{glm_coef} recognises objects (models) from the following classes: \code{clm}, \code{clogit},
\code{coxph}, \code{gee}, \code{glm}, \code{glmerMod}, \code{lm}, \code{lme}, \code{multinom}, \code{negbin},
\code{polr} and \code{surveg}

For models from logistic regression (including conditional logistic, ordinal and multinomial),
Poisson or survival analysis, coefficient estimates and corresponding confidence intervals are
automatically exponentiated (back-transformed).

By default, \code{glm_coef} uses robust standard errors for calculating confidence intervals.

\code{glm_coef} can display two different data frames depending on the option of \code{type},
for type \code{type = "cond"} (the default), \code{glm_coef} displays the standard table of coefficients
with confidence intervals and p-values; for \code{type = "ext"}, \code{glm_coef} displays each number
in a different column and includes standard errors.

Please read the Vignette on Regression for more details.
}
\examples{
require(dplyr)
require(sjlabelled)

## Continuous outcome.
data(birthwt, package = "MASS")
birthwt <- birthwt \%>\%
  mutate(
    smoke = factor(smoke, labels = c("Non-smoker", "Smoker")),
    race = factor(race, labels = c("White", "African American", "Other"))
  ) \%>\%
  var_labels(
    bwt = 'Birth weight (g)',
    smoke = 'Smoking status',
    race = 'Race'
  )

model_norm <- lm(bwt ~ smoke + race, data = birthwt)

glm_coef(model_norm, labels = model_labels(model_norm))

## Logistic regression.
data(diet, package = "Epi")
model_binom <- glm(chd ~ fibre, data = diet, family = binomial)
model_binom \%>\%
  glm_coef(labels = c("Constant", "Fibre intake (g/day)"))

model_binom \%>\%
  glm_coef(labels = c("Constant", "Fibre intake (g/day)"), type = "ext")

## For more examples, please read the Vignette on Regression.
}
