% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{theme_pubh}
\alias{theme_pubh}
\title{A theme for huxtables
This function quickly set a default style for a huxtable.}
\usage{
theme_pubh(ht, rw = 1)
}
\arguments{
\item{ht}{A huxtable object.}

\item{rw}{A numeric vector with the rows on which a bottom border is desired.}
}
\description{
A theme for huxtables
This function quickly set a default style for a huxtable.
}
\details{
\code{theme_pubh} is a variation of \code{theme_article} with the added flexibility
of adding a bottom border line at desired row numbers.
}
\examples{
require(dplyr, quietly = TRUE)
data(Oncho)

Oncho \%>\%
  select(area, mf) \%>\%
  cross_tbl(by = "area") \%>\%
  theme_pubh(2)

data(Bernard)

t1 <- estat(~ apache | fate, data = Bernard)
t2 <- estat(~ o2del | fate, data = Bernard)
rbind(t1, t2) \%>\%
  as_hux() \%>\%
  theme_pubh(c(1, 3))
}
