% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities-phnorm.R
\name{phnorm}
\alias{phnorm}
\alias{dphnorm}
\alias{rphnorm}
\alias{pphnorm}
\title{p-hacking Meta-analysis Model}
\usage{
dphnorm(x, theta, sigma, alpha = c(0, 0.025, 0.05, 1), eta, log = FALSE)

rphnorm(n, theta, sigma, alpha = c(0, 0.025, 0.05, 1), eta)

pphnorm(
  q,
  theta,
  sigma,
  alpha = c(0, 0.025, 0.05, 1),
  eta,
  lower.tail = TRUE,
  log.p = FALSE
)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{theta}{vector of means.}

\item{sigma}{vector of study standard deviations.}

\item{alpha}{vector of thresholds for p-hacking.}

\item{eta}{vector of p-hacking probabilities, normalized to sum to 1.}

\item{log, log.p}{logical; If \code{TRUE}, probabilities are given as
\code{log(p)}.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}

\item{lower.tail}{logical; If \code{TRUE} (default), the probabilities are
\eqn{P[X\leq x]} otherwise, \eqn{P[X\geq x]}.}
}
\value{
\code{dphnorm} gives the density, \code{pphnorm} gives the distribution
function, and \code{rphnorm} generates random deviates.
}
\description{
Density, distribution, and random variate generation for the p-hacking meta-
analysis model.
}
\details{
These functions assume one-sided selection on the effects. \code{alpha} contains
the selection thresholds and \code{eta} the vector of \emph{p}-hacking
probabilities. \code{theta} is the true effect, while \code{sigma} is the true
standard deviation before selection.
}
\examples{
rphnorm(100, theta = 0, sigma = 0.1, eta = c(1, 0.5, 0.1))
}
\references{
Moss, Jonas and De Bin, Riccardo. "Modelling publication
bias and p-hacking" Forthcoming (2019)
}
