% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getLamPath}
\alias{getLamPath}
\title{Lambda path}
\usage{
getLamPath(max, min, len, log = FALSE)
}
\arguments{
\item{max}{numeric, maximum lambda value}

\item{min}{numeric, minimum lambda value}

\item{len}{numeric/int, length of lambda path}

\item{log}{logical, should the lambda path be log-spaced}
}
\value{
numeric vector of lambdas
}
\description{
Generate a lambda path sequence in descending order, equally or log-spaced.
}
\examples{
## Generate the data with huge:
library(huge)
set.seed(10010)
p <- 40 ; n <- 100
dat   <- huge.generator(n, p, "hub", verbose=FALSE, v=.1, u=.3)

## Theoretical lamda max is the maximum abs value of the empirical covariance matrix
maxCov <- getMaxCov(dat$data)
lams   <- getLamPath(maxCov, 5e-2*maxCov, len=40)

}
\seealso{
\code{\link{getMaxCov}}
}

