% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generic.R
\name{predictExpression}
\alias{predictExpression}
\title{predict Expression}
\usage{
predictExpression(object, tg)
}
\arguments{
\item{object}{a 'pulseTDmodel' that has been calculated with \code{\link{estimateParams}}}

\item{tg}{A vector of points in time at which experimental data is collected, not allowed to be repeated}
}
\value{
Returns a list containing predicted values for each gene and a 0.95 confidence interval
}
\description{
It is used to predict the expression of all gene at a given time, including the expression of pre-mRNA (Precursor RNA) and the expression of total mRNA (Mature RNA).
End time and time interval can be arbitrarily defined
}
\examples{
data('pulseRates', package='pulseTD')
pulseRates_correct = correctionParams(pulseRates)
TimeGrid = seq(0,180,15)
\donttest{preExp = predictExpression(pulseRates_correct, tg=TimeGrid)}
data('preExp', packages='pulseTD')
df = data.frame(preExp[['NM_001002011']])
head(df)
}
