% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot.R
\name{snapshot}
\alias{snapshot}
\title{snapshot}
\usage{
snapshot(ri, ni, m1i, m2i, n1i, n2i, sd1i, sd2i, tobs, alpha)
}
\arguments{
\item{ri}{A vector of length two containing the raw correlation coefficients
of the original study and replication}

\item{ni}{A vector of length two containing the sample size of the original 
study and replication for the raw correlation coefficient}

\item{m1i}{A vector of length two containing the means in group 1 for the original
study and replication for two-independent means}

\item{m2i}{A vector of length two containing the means in group 2 for the original
and replication for two-independent means}

\item{n1i}{A vector of length two containing the sample sizes in group 1 for
the original study and replication for two-independent means}

\item{n2i}{A vector of length two containing the sample sizes in group 2 for
the original study and replication for two-independent means}

\item{sd1i}{A vector of length two containing the standard deviations in group 1
for the original study and replication for two-independent means}

\item{sd2i}{A vector of length two containing the standard deviations in group 2
for the original study and replication for two-independent means}

\item{tobs}{A vector of length two containing the t-values of the original
study and replication}

\item{alpha}{An integer specifying the alpha level as used in the original
study}
}
\value{
The \code{snapshot} function returns a data frame with posterior probabilities
for no (\code{p.0}), small (\code{p.sm}), medium (\code{p.me}), and large (\code{p.la})
true effect size.
}
\description{
Function for applying Snapshot Bayesian Hybrid Meta-Analysis Method for two-independent
means and raw correlation coefficients.
}
\details{
The function computes posterior probabilities (assuming a uniform prior
distribution) for four true effect sizes (no, small, medium, and large) based
on an original study and replication while taking into account statistical
significance in the original study. For more information see van Aert and van
Assen (2016).

Two different effect size measures can be used as input for the \code{snapshot}
function: two-independent means and raw correlation coefficients.
Analyzing two-independent means can be done by either providing
the function group means (\code{m1i} and \code{m2i}), standard deviations
(\code{sd1i} and \code{sd2i}), and sample sizes (\code{n1i} and \code{n2i}) or
t-values (\code{tobs}) and sample sizes (\code{n1i} and \code{n2i}). Both options
should be accompanied with input for the argument \code{alpha}. See the Example section for
an example. Raw correlation coefficients can be analyzed by supplying \code{ri}
and \code{ni} to the \code{snapshot} function next to input for the argument
\code{alpha}.

The \code{snapshot} function assumes that a two-tailed hypothesis test was
conducted in the original study. In case a one-tailed hypothesis test was
conducted in the original study, the alpha level has to be multiplied by two.
For example, if a one-tailed hypothesis test was conducted with an alpha level
of .05, an alpha of 0.1 has to be submitted to \code{snapshot}.
}
\examples{
### Example as presented on page 491 in Maxwell, Lau, and Howard (2015)
snapshot(ri = c(0.243, 0.114), ni = c(80, 172), alpha = .05)

}
\references{
van Aert, R.C.M. & van Assen, M.A.L.M. (2017). Bayesian evaluation
of effect size after replicating an original study. PLoS ONE, 12(4), e0175302. 
doi:10.1371/journal.pone.0175302
}
\author{
Robbie C.M. van Aert \email{R.C.M.vanAert@tilburguniversity.edu}
}
