% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffprior.R
\name{diffprior}
\alias{diffprior}
\title{diffprior}
\usage{
diffprior(prior, res.snap)
}
\arguments{
\item{prior}{A vector of length four containing the prior probabilities for no,
small, medium, and large true effect size.}

\item{res.snap}{A data frame with posterior probabilities obtained with the
\code{snapshot} or \code{uncor.snapshot} function.}
}
\value{
The \code{diffprior} function returns a data frame with posterior probabilities
for no (\code{p.0}), small (\code{p.sm}), medium (\code{p.me}), and large (\code{p.la})
true effect size.
}
\description{
Function for computing posterior probabilities based on the Snapshot Bayesian
Hybrid Meta-Analysis Method or Snapshot Bayesian Meta-Analysis Method (uncorrected)
for another than a uniform prior.
}
\details{
The function computes posterior probabilities for four true effect
sizes (no, small, medium, and large) based on the \code{snapshot} or
\code{uncor.snapshot} function for another than a uniform prior. For more
information see van Aert and van Assen (2016).
}
\examples{
### Example as presented on page 491 in Maxwell, Lau, and Howard (2015)
res.snap <- snapshot(ri=c(0.243, 0.114), ni=c(80, 172), alpha=.05)

### Prior probabilities with probablity for no effect twice as large as for the other true effects
prior <- c(0.4, 0.2, 0.2, 0.2)

### Compute posterior probabilities based on new prior
diffprior(prior = prior, res.snap = res.snap)

}
\references{
van Aert, R.C.M. & van Assen, M.A.L.M. (2017). Bayesian evaluation
of effect size after replicating an original study. PLoS ONE, 12(4), e0175302. 
doi:10.1371/journal.pone.0175302
}
\author{
Robbie C.M. van Aert \email{R.C.M.vanAert@tilburguniversity.edu}
}
