% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inbreeding.R
\encoding{UTF-8}
\name{ip_g}
\alias{ip_g}
\title{Purged inbreeding coefficient}
\usage{
ip_g(ped, d, name_to = "g<d>", Fcol = NULL)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{d}{Purging coefficient (taking values between 0.0 and 0.5).}

\item{name_to}{A string naming the new output column.}

\item{Fcol}{Name of column with inbreeding coefficient values. If none is used, inbreeding will be computed.}
}
\value{
The input dataframe, plus an additional column containing purged inbreeding coefficient values (named "g" and followed by the purging coefficient value by default).
}
\description{
Computes the purged inbreeding coefficient (\emph{g}).
This is the probability that two alleles on a locus are identical by descent,
but relative to deleterious recessive alleles (García-Dorado 2012). The reduction
in \emph{g} relative to standard inbreeding (\emph{F}) is given by an effective purging
coefficient (\emph{d}), that measures the strength of the deleterious recessive
component in the genome. The coefficient \emph{g} is computed following the methods
for pedigrees in García-Dorado (2012) and García-Dorado et al. (2016).
}
\examples{
data(dama)
ip_g(dama, d = 0.23)
}
\references{
\itemize{
  \item{García-Dorado. 2012. Understanding and predicting the fitness decline of shrunk populations: Inbreeding, purging, mutation, and standard selection. Genetics 190: 1-16.}
  \item{García-Dorado et al. 2016. Predictive model and software for inbreeding-purging analysis of pedigreed populations. G3 6: 3593-3601.}
}
}
\seealso{
\code{\link{ip_F}} \code{\link{exp_g}}
}
