% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial.R
\name{Fij_core}
\alias{Fij_core}
\title{Partial inbreeding coefficient (core function)}
\usage{
Fij_core(ped, ancestors, ancestors_idx, Fi, mapa, ncores = 1)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{ancestors}{Vector of the identities to be assumed as founder ancestors.}

\item{ancestors_idx}{Index of ancestors.}

\item{Fi}{Vector of inbreeding coefficients.}

\item{mapa}{Map of ancestors}

\item{ncores}{Number of cores to use for parallel computing (default = 1)}
}
\value{
A matrix of partial inbreeding coefficients. Fi(j) values can thus be read from row i and column j.
}
\description{
Computes partial inbreeding coefficients, Fi(j).
A coefficient Fi(j) can be read as the probability of individual i being
homozygous for alleles derived from ancestor j
}
