% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{safely}
\alias{safely}
\alias{quietly}
\alias{possibly}
\title{Capture side effects.}
\usage{
safely(.f, otherwise = NULL, quiet = TRUE)

quietly(.f)

possibly(.f, otherwise, quiet = TRUE)
}
\arguments{
\item{.f}{A function, formula, or atomic vector.

  If a \strong{function}, it is used as is.

  If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a
  function with two arguments, \code{.x} or \code{.} and \code{.y}. This
  allows you to create very compact anonymous functions with up to
  two inputs.

  If \strong{character} or \strong{integer vector}, e.g. \code{"y"}, it
  is converted to an extractor function, \code{function(x) x[["y"]]}. To
  index deeply into a nested list, use multiple values; \code{c("x", "y")}
  is equivalent to \code{z[["x"]][["y"]]}. You can also set \code{.null}
  to set a default to use instead of \code{NULL} for absent components.}

\item{otherwise}{Default value to use when an error occurs.}

\item{quiet}{Hide errors (\code{TRUE}, the default), or display them
as they occur?}
}
\value{
\code{safe}: a list with components \code{result} and \code{error}.
  One value is always \code{NULL}

\code{outputs}: a list with components \code{result}, \code{output},
  \code{messages} and \code{warnings}.
}
\description{
These functions wrap functions so instead generating side effects through
output, messages, warnings, and errors, they instead return enchanced
output. They are all adverbs because they modify the action of a
verb (a function).
}
\examples{
safe_log <- safely(log)
safe_log(10)
safe_log("a")

list("a", 10, 100) \%>\%
  map(safe_log) \%>\%
  transpose()

# This is a bit easier to work with if you supply a default value
# of the same type and use the simplify argument to transpose():
safe_log <- safely(log, otherwise = NA_real_)
list("a", 10, 100) \%>\%
  map(safe_log) \%>\%
  transpose() \%>\%
  simplify_all()

# To replace errors with a default value, use possibly().
list("a", 10, 100) \%>\%
  map_dbl(possibly(log, NA_real_))
}
