% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id.R
\name{id.grt}
\alias{id.grt}
\title{Identification of SVEC models by imposing long- and short-run restrictions}
\usage{
id.grt(
  x,
  LR = NULL,
  SR = NULL,
  start = NULL,
  max.iter = 100,
  conv.crit = 1e-07,
  maxls = 1
)
}
\arguments{
\item{x}{VAR object of class '\code{varx}' estimated under rank-restriction 
or any other that will be \link[=as.varx]{coerced} to '\code{varx}'.}

\item{LR}{Matrix. The restricted long-run impact matrix.}

\item{SR}{Matrix. The restricted contemporaneous impact matrix.}

\item{start}{Vector. The starting values for \eqn{\gamma}, 
set by \code{\link[stats]{rnorm}} if \code{NULL} (the default).}

\item{max.iter}{Integer. The maximum number of iterations.}

\item{conv.crit}{Real number. Convergence value of algorithm.}

\item{maxls}{Real number. Maximum movement of the parameters between two iterations of the scoring algorithm.}
}
\value{
List of class '\code{\link[=as.varx]{id}}'.
}
\description{
Identifies an SVEC model by utilizing a scoring algorithm 
  to impose long- and short-run restrictions. 
  See the details of \code{\link[vars]{SVEC}} in \strong{vars}.
}
\examples{
### reproduce basic example in "vars" ###
library(vars)
data("Canada")
names_k = c("prod", "e", "U", "rw")  # variable names
names_s = NULL  # optional shock names

# colnames of the restriction matrices are passed as shock names #
SR = matrix(NA, nrow=4, ncol=4, dimnames=list(names_k, names_s))
SR[4, 2] = 0
LR = matrix(NA, nrow=4, ncol=4, dimnames=list(names_k, names_s))
LR[1, 2:4] = 0
LR[2:4, 4] = 0

# estimate and identify SVECM #
R.vecm = VECM(y=Canada[ , names_k], dim_p=3, dim_r=1, type="Case4")
R.grt  = id.grt(R.vecm, LR=LR, SR=SR)

}
\references{
Amisano, G. and Giannini, C. (1997): 
  \emph{Topics in Structural VAR Econometrics}, 
  Springer, 2nd ed.

Breitung, J., Brueggemann R., and Luetkepohl, H. (2004): 
  "Structural Vector Autoregressive Modeling and Impulse Responses", 
  in \emph{Applied Time Series Econometrics}, 
  ed. by H. Luetkepohl and M. Kraetzig, 
  Cambridge University Press, Cambridge.

Johansen, S. (1996): 
  \emph{Likelihood-Based Inference in Cointegrated Vector Autoregressive Models}, 
  Advanced Texts in Econometrics, Oxford University Press, USA.

Luetkepohl, H. (2005): 
  \emph{New Introduction to Multiple Time Series Analysis}, 
  Springer, 2nd ed.

Pfaff, B. (2008):
  "VAR, SVAR and SVEC Models: Implementation within R Package \strong{vars}",
  \emph{Journal of Statistical Software}, 27, pp. 1-32.
}
\seealso{
\ldots the original \code{\link[vars]{SVEC}} by Pfaff (2008) in \strong{vars}. 
  Note that \code{\link{id.grt}} is just a graftage, but allows for the additional 
  model specifications in \code{\link{VECM}} and for the bootstrap procedures 
  in \code{\link{sboot.mb}}, both provided by the \strong{pvars} package.

Other identification functions: 
\code{\link{id.iv}()}
}
\concept{identification functions}
