% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/exp_weights.R
\name{exp_weights}
\alias{exp_weights}
\title{Exponential p-value weights}
\usage{
exp_weights(mu, beta = 2, UB = Inf)
}
\arguments{
\item{mu}{the estimated means of the test statistics}

\item{beta}{(optional) weights are proportional to \code{exp(mu*beta)}, default \code{beta=2}}

\item{UB}{(optional) upper bound on the weights (default \code{UB = Inf})}
}
\value{
The exponential weights.
}
\description{
Computes the exponential p-value weights for multiple testing.
Given estimated means \code{mu} of test statistics \code{T},
the p-value weights are proportional to \code{exp(beta*mu)},
for a tilt parameter \code{beta}. In addition, the large weights are truncated
at a maximum value \code{UB} (upper bound), and the remaining weight is re-distributed
among the rest of the statistics.
}
\details{
Specifically, it is assumed that \code{T} are Gaussian with mean
\code{mu}. One-sided tests of \code{mu>=0} against \code{mu<0}
 are conducted using the test statistics \code{T}. To optimize power,
 different levels are allocated to different tests.
 For more details, see the paper "Optimal Multiple Testing Under a
 Gaussian Prior on the Effect Sizes", by Dobriban, Fortney, Kim and Owen,
  \url{http://arxiv.org/abs/1504.02935}
}
\examples{
J <- 100
mu <- rnorm(J)
beta <- 2
UB <- 20
w <- exp_weights(mu, beta, UB)
}
\seealso{
\code{\link{bayes_weights}} for Bayes, \code{\link{spjotvoll_weights}} for Spjotvoll weights, and \code{\link{exp_weights}} for exponential
  weights

Other p.value.weighting: \code{\link{bayes_weights}};
  \code{\link{iGWAS}}; \code{\link{spjotvoll_weights}}
}

