% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/spjotvoll_weights.R
\name{spjotvoll_weights}
\alias{spjotvoll_weights}
\title{Spjotvoll p-value weights}
\usage{
spjotvoll_weights(mu, q)
}
\arguments{
\item{mu}{a negative vector, the estimated means of test statistics}

\item{q}{level at which tests will be performed}
}
\value{
The optimal Spjotvoll weights.
}
\description{
Computes the Spjotvoll p-value weights for multiple testing.
Given estimated means \code{mu} of test statistics \code{T},
the weighting scheme optimizes the expected number of discoveries
using \code{T} as test statistics in multiple testing
at some specific level \code{q}.
}
\details{
Specifically, it is assumed that \code{T} are Gaussian with mean
\code{mu}. One-sided tests of \code{mu>=0} against \code{mu<0}
 are conducted using the test statistics \code{T}. To optimize power,
 different levels are allocated to different tests.
 For more details, see the paper "Optimal Multiple Testing Under a
 Gaussian Prior on the Effect Sizes", by Dobriban, Fortney, Kim and Owen,
  \url{http://arxiv.org/abs/1504.02935}
}
\examples{
J <- 100
mu <- -abs(rnorm(J))
q <- 0.05 / J
w <- spjotvoll_weights(mu, q)
}
\seealso{
Other p.value.weighting: \code{\link{bayes_weights}};
  \code{\link{exp_weights}}; \code{\link{iGWAS}}
}

