% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R2ch.R
\name{R2ch}
\alias{R2ch}
\title{Compute power for R2 change in Multiple Regression (up to three predictors)
Requires correlations between all variables as sample size. Means, sds, and alpha are option. Also computes Power(All)
Example code below for three predictors. Expand as needed for four or five}
\usage{
R2ch(ry1 = NULL, ry2 = NULL, ry3 = NULL, r12 = NULL, r13 = NULL,
  r23 = NULL, n = NULL, alpha = 0.05, my = 0, m1 = 0, m2 = 0,
  m3 = 0, s1 = 1, s2 = 1, s3 = 1, sy = 1)
}
\arguments{
\item{ry1}{Correlation between DV (y) and first predictor (1)}

\item{ry2}{Correlation between DV (y) and second predictor (2)}

\item{ry3}{Correlation between DV (y) and third predictor (3)}

\item{r12}{Correlation between first (1) and second predictor (2)}

\item{r13}{Correlation between first (1) and third predictor (3)}

\item{r23}{Correlation between second (2) and third predictor (3)}

\item{n}{Sample size}

\item{alpha}{Type I error (default is .05)}

\item{my}{Mean of DV (default is 0)}

\item{m1}{Mean of first predictor (default is 0)}

\item{m2}{Mean of second predictor (default is 0)}

\item{m3}{Mean of third predictor (default is 0)}

\item{s1}{Standard deviation of first predictor (default is 1)}

\item{s2}{Standard deviation of second predictor (default is 1)}

\item{s3}{Standard deviation of third predictor (default is 1)}

\item{sy}{Standard deviation of DV (default is 1)}
}
\value{
Power for R2 change in Multiple Regression (up to three predictors)
}
\description{
Compute power for R2 change in Multiple Regression (up to three predictors)
Requires correlations between all variables as sample size. Means, sds, and alpha are option. Also computes Power(All)
Example code below for three predictors. Expand as needed for four or five
}
\examples{
R2ch(ry1=.40,ry2=.40,ry3=-.40, r12=-.15, r13=-.60,r23=.25,n=24)
}
