% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa2.0.R
\name{qspec2qcoh}
\alias{qspec2qcoh}
\title{Quantile Coherence Spectrum}
\usage{
qspec2qcoh(qspec, k = 1, kk = 2)
}
\arguments{
\item{qspec}{array of quantile spectrum/cross-spectrum}

\item{k}{index of first series (default = 1)}

\item{kk}{index of second series (default = 2)}
}
\value{
matrix of quantile coherence evaluated at Fourier frequencies in (0,0.5)
}
\description{
This function computes quantile coherence spectrum (QCOH) from quantile spectrum and cross-spectrum of multiple time series.
}
\examples{
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
tau <- seq(0.1,0.9,0.05)
n <- length(y1)
ff <- c(0:(n-1))/n
sel.f <- which(ff > 0 & ff < 0.5)
y.qacf <- qacf(cbind(y1,y2),tau)
y.qper.lw <- qspec.lw(y.qacf,M=5)$spec
y.qcoh <- qspec2qcoh(y.qper.lw,k=1,kk=2)
qfa.plot(ff[sel.f],tau,y.qcoh)
}
