% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa2.1.R
\name{qper2}
\alias{qper2}
\title{Quantile Periodogram Type II (QPER2)}
\usage{
qper2(y, freq, tau, weights = NULL, n.cores = 1, cl = NULL)
}
\arguments{
\item{y}{univariate time series}

\item{freq}{sequence of frequencies in [0,1)}

\item{tau}{sequence of quantile levels in (0,1)}

\item{weights}{sequence of weights in quantile regression (default = \code{NULL}: weights equal to 1)}

\item{n.cores}{number of cores for parallel computing (default = 1)}

\item{cl}{pre-existing cluster for repeated parallel computing (default = \code{NULL})}
}
\value{
matrix of quantile periodogram evaluated on \code{freq * tau} grid
}
\description{
This function computes type-II quantile periodogram for univariate time series.
}
\examples{
y <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
n <- length(y)
ff <- c(0:(n-1))/n
sel.f <- which(ff > 0 & ff < 0.5)
y.qper2 <- qper2(y,ff,tau)
qfa.plot(ff[sel.f],tau,Re(y.qper2[sel.f,]))
}
