% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_statistics.R
\name{adjStat}
\alias{adjStat}
\title{LD adjustment of marker summary statistics}
\usage{
adjStat(
  stat = NULL,
  Glist = NULL,
  chr = NULL,
  statistics = "b",
  r2 = 0.9,
  ldSets = NULL,
  threshold = 1,
  header = NULL,
  method = "pruning"
)
}
\arguments{
\item{stat}{a data frame with marker summary statistics (see required format above)}

\item{Glist}{list of information about genotype matrix stored on disk}

\item{chr}{chromosome(s) being processed}

\item{statistics}{specificy what type of statistics ("b" or "z") is being processed (default is "b")}

\item{r2}{threshold used in clumping/pruning procedure (default is 0.9)}

\item{ldSets}{list of marker sets - names corresponds to row names in stat}

\item{threshold}{p-value threshold used in clumping procedure (default is 1)}

\item{header}{character vector with column names to be excluded in the LD adjustment}

\item{method}{method used in adjustment for linkage disequilibrium (default is "clumping")}
}
\description{
Adjust marker summary statistics using linkage disequilibrium information from Glist

Required input format for summary statistics:

stat can be a data.frame(rsids, chr, pos, a1, a2, af, b, seb, stat, p, n)     (single trait)

stat can be a list(marker=(rsids, chr, pos, a1, a2, af), b, seb, stat, p, n)  (multiple trait)
}
\details{
stat can be a data.frame(rsids, chr, pos, a1, a2, af, b, seb, stat, p, n)     (single trait)

stat can be a list(marker=(rsids, chr, pos, a1, a2, af), b, seb, stat, p, n)  (multiple trait)
}
\author{
Peter Soerensen
}
