% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_matrix.R
\name{getSparseLD}
\alias{getSparseLD}
\title{Extract Sparse Linkage Disequilibrium (LD) Information}
\usage{
getSparseLD(
  Glist = NULL,
  chr = NULL,
  r2 = 0,
  onebased = TRUE,
  rsids = NULL,
  format = "sparse"
)
}
\arguments{
\item{Glist}{A list containing details such as the LD file path, msize, rsids for LD.}

\item{chr}{A numeric value representing the chromosome for which LD data is to be extracted.}

\item{r2}{A numeric value specifying the LD threshold for extraction. Default is 0.}

\item{onebased}{A logical value indicating whether indices are one-based (default) or zero-based.}

\item{rsids}{A vector of rsids for which the LD data needs to be extracted in dense format. Default is NULL.}

\item{format}{A character string specifying the format of the result, either "sparse" (default) or "dense".}
}
\value{
If `format` is "sparse", a list with two components: `indices` and `values`. Each component is a list 
of length equal to the number of rsids in the specified chromosome. If `format` is "dense", a matrix with rows 
and columns named after the rsids is returned.
}
\description{
Retrieves and formats linkage disequilibrium (LD) data from binary files based on a specified chromosome and LD threshold.
It provides options for returning the data in sparse or dense format.
}
\keyword{internal}
