% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgis-result.R
\name{qgis_extract_output}
\alias{qgis_extract_output}
\alias{qgis_extract_output_by_name}
\alias{qgis_extract_output_by_position}
\alias{qgis_extract_output_by_class}
\title{Access processing output}
\usage{
qgis_extract_output_by_name(x, name = "OUTPUT", first = TRUE)

qgis_extract_output(x, name = "OUTPUT", first = TRUE)

qgis_extract_output_by_position(x, which)

qgis_extract_output_by_class(x, class, single = TRUE)
}
\arguments{
\item{x}{A \code{qgis_result} object returned by \code{\link[=qgis_run_algorithm]{qgis_run_algorithm()}}.}

\item{name}{The name of an output.}

\item{first}{Logical.
Should \code{qgis_extract_output_by_name()} fall back to the first
output element if the default \code{OUTPUT} or \code{output} element is not available?
Only takes effect if \code{name} is equal to \code{OUTPUT} or \code{output}, but not found.}

\item{which}{The index of an output.}

\item{class}{Character vector of classes.
At least one class must be inherited by an element of \code{x} for that element
to be selected.}

\item{single}{Logical.
Ensures the selection of a single output in \code{qgis_extract_output_by_class()}.
The \code{OUTPUT} or \code{output} element is taken if available and on condition that
it inherits a specified class; otherwise falls back
to the first element that inherits a specified class.}
}
\value{
A \verb{qgis_output*} object.
}
\description{
These functions extract one output element from the result of
\code{\link[=qgis_run_algorithm]{qgis_run_algorithm()}}, potentially more than one in the case of
\code{qgis_extract_output_by_class()}.
An output element can be extracted based on its name, its position in the
printed \code{qgis_result} object returned by \code{\link[=qgis_run_algorithm]{qgis_run_algorithm()}}, or its
class.

\code{qgis_extract_output()} is an alias to \code{qgis_extract_output_by_name()}.
}
\examples{
\dontshow{if (has_qgis()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
result <- qgis_run_algorithm(
  "native:buffer",
  INPUT = system.file("longlake/longlake_depth.gpkg", package = "qgisprocess"),
  DISTANCE = 10
)

# the print() method of a qgis_result only prints its output elements:
result

# nevertheless, more elements are included:
length(result)
names(result)

# extract the output element 'OUTPUT':
qgis_extract_output(result)
\dontshow{\}) # examplesIf}
}
\seealso{
Other topics about accessing or managing processing results: 
\code{\link{qgis_as_raster}()},
\code{\link{qgis_as_terra}()},
\code{\link{qgis_clean_result}()},
\code{\link{qgis_result_status}()},
\code{\link{st_as_sf}},
\code{\link{st_as_stars}}
}
\concept{main functions to access or manage processing results}
\concept{topics about accessing or managing processing results}
