% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compat-sf.R
\name{st_as_sf}
\alias{st_as_sf}
\alias{st_as_sf.qgis_result}
\alias{st_as_sf.qgis_outputVector}
\alias{st_as_sf.qgis_outputLayer}
\title{Convert a qgis_result object or one of its elements to an sf object}
\usage{
\method{st_as_sf}{qgis_result}(x, ...)

\method{st_as_sf}{qgis_outputVector}(x, ...)

\method{st_as_sf}{qgis_outputLayer}(x, ...)
}
\arguments{
\item{x}{A \code{qgis_result} object from \code{\link[=qgis_run_algorithm]{qgis_run_algorithm()}} or a
\verb{qgis_output*} object from one of the \code{\link[=qgis_extract_output]{qgis_extract_output()}} functions.}

\item{...}{Arguments passed to \code{\link[sf:st_read]{sf::read_sf()}}.}
}
\value{
An \code{sf} object.
}
\description{
Convert a qgis_result object or one of its elements to an sf object
}
\details{
The sf package must be loaded explicitly to use these methods.
}
\examples{
\dontshow{if (has_qgis() && requireNamespace("sf", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# not running below examples in R CMD check to save time
result <- qgis_run_algorithm(
  "native:buffer",
  INPUT = system.file("longlake/longlake_depth.gpkg", package = "qgisprocess"),
  DISTANCE = 10
)

# most direct approach, autoselecting a `qgis_outputVector` type
# output from the `result` object and reading as sf object:
sf::st_as_sf(result)

# if you need more control, extract the needed output element first:
output_vector <- qgis_extract_output(result, "OUTPUT")
sf::st_as_sf(output_vector)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other topics about coercing processing output: 
\code{\link{qgis_as_raster}()},
\code{\link{qgis_as_terra}()},
\code{\link{st_as_stars}}

Other topics about accessing or managing processing results: 
\code{\link{qgis_as_raster}()},
\code{\link{qgis_as_terra}()},
\code{\link{qgis_clean_result}()},
\code{\link{qgis_extract_output}()},
\code{\link{qgis_result_status}()},
\code{\link{st_as_stars}}
}
\concept{topics about accessing or managing processing results}
\concept{topics about coercing processing output}
