% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qleTest.R
\name{checkMultRoot}
\alias{checkMultRoot}
\title{Inspect estimated parameters}
\usage{
checkMultRoot(est, par = NULL, verbose = FALSE)
}
\arguments{
\item{est}{object of class \code{qle}, the estimation results from function \code{\link{qle}}}

\item{par}{list or matrix of estimated parameters as roots of the quasi-score vector}

\item{verbose}{logical, \code{TRUE} for intermediate output}
}
\value{
A data frame with columns named corresponding to each component of the investigated parameter,
 `\code{quasi-deviance}`, `\code{Minor}`, `\code{det}`, `\code{max}`,
 `\code{trace}` and `\code{score_max}` (see vignette). The second column shows the leading minor of
  the observed QI matrix which is not positive definite. If so, then the corresponding parameter estimate
  cannot be consistent at least in theory. The rows show the corresponding values for each parameter passed by
  `\code{par}`.
}
\description{
Check out and compare estimated roots of the quasi-score vector
}
\details{
Only for the quasi-likelihood approach the function inspects the (numerical) consistency of the found
 parameters in `\code{par}` by comparing each observed quasi-information matrix with the expected one.
 The degree of dissimilarity of both matrices is measured by certain scalar equivalent criteria (see vignette)
 and the parameter for which these are smallest is chosen.
}
\examples{
 data(normal)
 # a dummy estimation result
 OPT <- qle(qsd,qsd$sim,global.opts=list("maxeval"=0))
 
 # and just a single root 
 checkMultRoot(OPT,verbose=TRUE)

}
\author{
M. Baaske
}
