% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/krige.R
\name{predictKM}
\alias{predictKM}
\alias{varKM}
\alias{extract}
\title{Kriging the sample means of statistics}
\usage{
predictKM(models, ...)

varKM(models, ...)

extract(X, type = c("mean", "sigma2", "weights"))
}
\arguments{
\item{models}{list of covariance models, see \code{\link{setCovModel}}}

\item{...}{further arguments passed to function \code{\link{estim}}}

\item{X}{kriging result}

\item{type}{return type of results, see details below}
}
\value{
\item{predictKM}{ list of kriging predicted values}

\item{varKM}{ list of kriging prediction variances}

\item{\code{extract}}{matrix of corresponding values (see details)}
}
\description{
\describe{
   \item{\code{predictKM},}{wrapper for kriging the sample means of statistics} 	  
  \item{\code{varKM},}{ calculate the kriging prediction variances}
  \item{\code{extract},}{ extract the results of kriging} 
 }
}
\details{
For a list of fitted covariance models the function \emph{predictKM} predicts the
	 sample means of statistics at (unsampled) points, calculates the prediction
	 variances (if `\code{krig.type}` equals "\code{var}") at these points and extracts the results.
	 Note that, since we aim on predicting the simulation "error free" value of the sample means,
  we use a \emph{smoothing} kriging predictor (see [2, Sec. 3.7.1]).

The function \emph{extract} either returns the predicted values, the
 prediction variances or the kriging weights for each point.
}
\examples{
data(normal)
X <- as.matrix(qsd$qldata[,1:2])
p <- c("mu"=2,"sd"=1)

# get simulated statistics at design X
Tstat <- qsd$qldata[grep("^mean.",names(qsd$qldata))]

# predict and extract 
predictKM(qsd$covT,p,X,Tstat)

# prediction variances
varKM(qsd$covT,p,X,Tstat)

}
