% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.par.th.r
\name{calc.par.th}
\alias{calc.par.th}
\title{Calculate Lambda_z Parameters}
\usage{
calc.par.th(
  x,
  by = character(0),
  th = th,
  covariates = NA,
  dose = "dose",
  factor = 1,
  reg = "SD",
  ss = "N",
  route = "EV"
)
}
\arguments{
\item{x}{result parameter dataset from \code{\link{calc.par}}}

\item{by}{column names in x indicating grouping variables}

\item{th}{result dataset from \code{\link{est.thalf}}}

\item{covariates}{covariates dataset (containing at least dose for CL calculation); defaults to unique combinations of \code{by} and \code{dose} evaluated on \code{x}; can be character name of csv file or local object}

\item{dose}{variable containing the dose amount; default 'dose' set to 1 if not in \code{names(x)}}

\item{factor}{conversion factor for CL and V calculation (e.g. dose in mg, conc in ng/mL, factor=1000); x$factor overrides}

\item{reg}{regimen, "sd" or "md"; x$reg overrides}

\item{ss}{is steady state reached (y/n); x$ss overrides}

\item{route}{of drug administration ("EV","IVB","IVI"); x$route overrides}
}
\value{
A dataset containing all parameters calculated in \code{\link{est.thalf}} and \code{\link{calc.par}} \cr
with estimates for the following parameters added, one observation per subject:\tabular{ll}{
   \strong{Parameter} \tab \strong{Description} \cr
   clast.pred \tab predicted concentration at tlast \cr
   aucinf.obs \tab aucinf based on observed concentration at tlast \cr
   aucinf.pred \tab aucinf based on predicted concentration at tlast \cr
   aumcinf.obs \tab area under the first moment curve extrapolated to infinity, based on observed concentration at tlast \cr
   aumcinf.pred \tab area under the first moment curve extrapolated to infinity, based on predicted concentration at tlast \cr
   cl.obs, cl.f.obs \tab clearance based on aucinf.obs, at steady state based on auctau \cr
   cl.pred, cl.f.pred \tab clearance based on aucinf.pred \cr
   cl.ss, cl.f.ss \tab clearance at steady state, based on auctau \cr
   mrt.obs \tab mean residence time based on aumcinf.obs and aucinf.obs \cr
   mrt.pred \tab mean residence time based on aumcinf.pred and aucinf.pred \cr
   vz.obs, vz.f.obs \tab distribution volume based on cl.f.obs, at steady state based on auctau \cr
   vz.pred, vz.f.pred \tab distribution based on cl.pred/cl.f.pred \cr
   vss.obs \tab steady-state volume based on cl.obs and mrt.obs \cr
   vss.pred \tab steady-state volume based on cl.pred and mrt.pred \cr
   pctextr.pred \tab percentage of AUC extrapolated to infinity, based on aucinf.pred \cr
   pctextr.obs \tab percentage of AUC extrapolated to infinity, based on aucinf.obs \cr
   pctback.pred \tab percentage of AUC extrapolated back to 0, based on aucinf.pred \cr
   pctback.obs \tab percentage of AUC extrapolated back to 0, based on aucinf.obs \cr
}


Note: ctmax must be merged separately as those were calculated from uncorrected data.
}
\description{
Calculates PK parameters that need lambda_z.
}
\examples{
\donttest{
example(calc.par) # creates par
# notice x includes (optional) loqrule, includeCmax, reg, method, route, ss
covs <- Theoph \%>\%
  select(subject = Subject, Wt, dose = Dose) \%>\%
  unique \%>\%
  mutate(dose = dose * Wt, subject=as.numeric(as.character(subject))) # see ?Theoph
y <- x \%>\% select(subject, reg, ss, loqrule) \%>\% unique
y \%<>\% mutate(factor = 1)
par \%<>\% left_join(y, by = 'subject')
par \%<>\% calc.par.th(by = 'subject', th = th, covariates = covs)
par \%<>\% left_join(ctmax, ., by = 'subject')
par \%>\% head
par \%>\% data.frame \%>\% head(2)
}
}
