% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.thalf.r
\name{est.thalf}
\alias{est.thalf}
\title{Calculate Lambda_z and Elimination Half-life}
\usage{
est.thalf(
  x,
  by = character(0),
  timevar = "time",
  depvar = "dv",
  includeCmax = "Y",
  exclvar = NA
)
}
\arguments{
\item{x}{a dataset}

\item{by}{column names in x indicating grouping variables}

\item{timevar}{variable name containing the actual sampling time after dose}

\item{depvar}{variable name containing the dependent variable (e.g., concentration)}

\item{includeCmax}{include results of regression including Cmax in selection? (y/n); x$includeCmax overrides if provided}

\item{exclvar}{a variable name containing information about points to be excluded (these should have exclvar = 1)}
}
\value{
a dataset with estimates for each regression analysis in one observation.
The following parameters are available.
\itemize{
\item \strong{no.points} number of data points used in the regression analysis
\item \strong{intercept} estimated intercept
\item \strong{lambda_z} -1*estimated slope
\item \strong{r.squared} square of the correlation coefficient
\item \strong{adj.r.squared} adjusted square of the correlation coefficient
\item \strong{thalf} elimination half-life
\item \strong{start_th} time of first sample included in the thalf estimation
\item \strong{end_th time} of last sample included in the thalf estimation
\item \strong{includeCmax} include results of regression including Cmax in selection? (y/n)
\item \strong{points_excluded} are time points excluded from the half-life estimation? (y/n)
}
}
\description{
Calculates lambda_z and thalf for each PK curve identified using \code{by}. \cr
}
\details{
The function starts with the last three sample points and performs
log-linear regression on it. It then adds one sampling point at a time
(including and ending at tmax) and performs the regression again.
The results of the regression with the highest adjusted R-squared are returned. \cr
\cr
Visual outliers can be excluded from the regression analysis.
}
\examples{
\donttest{
example(correct.loq)
x \%<>\% mutate(includeCmax = 'Y')
th <- x \%>\% est.thalf(by='subject',exclvar=)
th \%>\%  head
}
}
