% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkDisp.R
\name{checkDisp}
\alias{checkDisp}
\title{Reproduce data for the linear model scale-location diagnostic plot}
\usage{
checkDisp(x, span = 0.75)
}
\arguments{
\item{x}{Model fitted using \code{lm()} or \code{glm()}}

\item{span}{span parameter for use in smoothing the square
root of standardized deviance residuals.}
}
\value{
A data frame, with:
\item{linpred}{Predicted values, on the scale of the linear predictor}
\item{absrSmooth}{Smoothed values of the square roots of absolute
values of standardised deviance residuals.}
}
\description{
The values returned are those used for \code{plot(x.lm, which=3)},
where \code{x.lm} is a linear model or a generalized linear model.
Plot the object returned to assess how successful the weights,
determined using the function \code{\link{scaleLocAdjust}}, have been
in adjusting for heterogenous variances.
}
\examples{
royal <- subset(qra::codling1988, Cultivar=="ROYAL")
royal.glm <- glm(cbind(dead,total-dead)~ct, data=royal,
                 family=quasibinomial(link='cloglog'))
royalFix <- qra::scaleLocAdjust(royal.glm, lambda=2)
## Check range of indicated prior weights
range(royalFix[[2]])
## Range of updated dispersion estimates
range(summary(royalFix[[1]])[['dispersion']]/royalFix[[2]])
xy <- qra::checkDisp(royalFix[[1]])
plot(xy)
}
