% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\docType{methods}
\name{swapVariables}
\alias{swapVariables}
\alias{swapVariables,qspray,numeric,numeric-method}
\title{Swap variables}
\usage{
\S4method{swapVariables}{qspray,numeric,numeric}(x, i, j)
}
\arguments{
\item{x}{a \code{qspray} object}

\item{i, j}{indices of the variables to be swapped}
}
\value{
A \code{qspray} object.
}
\description{
Swap two variables in a \code{qspray} polynomial.
}
\examples{
library(qspray)
f <- function(x, y, z) {
  x^2 + 5*y + z - 1
}
x <- qlone(1)
y <- qlone(2)
z <- qlone(3)
P <- f(x, y, z)
Q <- swapVariables(P, 2, 3)
Q == f(x, z, y) # should be TRUE
}
