% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yacas.R
\name{as.function.qspray}
\alias{as.function.qspray}
\title{Multivariate polynomial as function}
\usage{
\method{as.function}{qspray}(x, N = FALSE, ...)
}
\arguments{
\item{x}{object of class \code{qspray}}

\item{N}{Boolean, whether the function must numerically approximate 
the result}

\item{...}{ignored}
}
\value{
A function having the same variables as the polynomial. If 
  \code{N=FALSE}, it returns a string. If \code{N=TRUE}, it returns a number 
  if the result does not contain any variable, otherwise it returns a 
  R expression.
}
\description{
Coerces a \code{qspray} polynomial into a function.
}
\examples{
library(qspray)
P <- (qlone(1) + "1/2"*qlone(2))^2 + 5
f <- as.function(P)
g <- as.function(P, N = TRUE)
f(2, "3/7")
g(2, "3/7")
f("x", "y")
g("x", "y")
# the evaluation is performed by (R)yacas and complex numbers are
# allowed; the imaginary unit is denoted by `I`
f("2 + 2*I", "Sqrt(2)")
g("2 + 2*I", "Sqrt(2)")
}
